/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;

import jp.mosp.common.common.MospException;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

/**
 * Excelt@CǍ[eBeB
 * <p>	2008/11/28	</p>
 * @author m.yoshida
 * @since		1.1.4
 * @version	0.0.2
 */
public class PoiReadUtility {

	/**
	 * V[g
	 */
	protected static final String SHEET_NAME = "Sheet1";

	/**
	 * POIFSFileSystem
	 */
	private POIFSFileSystem fs;

	/**
	 * [NubN
	 */
	private HSSFWorkbook wb;
	
	/**
	 * V[g
	 */
	private HSSFSheet sheet;
	
	/**
	 * 
	 */
	private HSSFRow row;
	
	/**
	 * Z
	 */
	private HSSFCell cell;
	
	/**
	 * ftHgRXgN^
	 */
	public PoiReadUtility() {
		// 
	}
	
	/**
	 * RXgN^
	 * @param filePath	΃t@CpX
	 */
	public PoiReadUtility(String filePath) {
		try {
			readFile(filePath);
			setWorkBook();
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * RXgN^
	 * @param file		t@C
	 */
	public PoiReadUtility(File file) {
		try {
			readFile(file);
			setWorkBook();
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * t@C̓ǂݍ
	 * @param filePath					΃t@CpX
	 * @throws FileNotFoundException
	 * @throws IOException
	 */
	private void readFile(String filePath) throws FileNotFoundException, IOException {
		fs = new POIFSFileSystem(new FileInputStream(filePath));
	}

	/**
	 * t@C̓ǂݍ
	 * @param file						t@C
	 * @throws FileNotFoundException
	 * @throws IOException
	 */
	private void readFile(File file) throws FileNotFoundException, IOException {
		fs = new POIFSFileSystem(new FileInputStream(file));
	}

	/**
	 * [NubN̏
	 * @throws IOException
	 */
	private void setWorkBook() throws IOException {
		wb = new HSSFWorkbook(fs);
	}

	/**
	 * V[g擾
	 * @return sheet
	 */
	protected HSSFSheet getSheet() {
		return sheet;
	}

	/**
	 * V[gݒ
	 */
	protected void setSheet() throws MospException {
		sheet = wb.getSheet(SHEET_NAME);
		if (sheet == null) {
			throw new MospException(MospConst.EX_NO_SHEET, MospConst.LOG_MSG_1040);
		}
	}
	
	/**
	 * V[gݒiwV[gj
	 * @param sheetname		V[g
	 * @throws MospException 
	 */
	protected void setSheet(String sheetname) throws MospException {
		sheet = wb.getSheet(sheetname);
		if (sheet == null) {
			setSheet();
		}
	}

	/**
	 * Zݒ
	 * @param cellno	cellԍ
	 */
	protected void setCell(short cellno) {
		cell = row.getCell(cellno);
	}

	/**
	 * ݒ
	 * @param row		rowԍ
	 */
	protected void setRow(HSSFRow row) {
		this.row = row;
	}

	/**
	 * Z擾
	 * @return	cell
	 */
	protected HSSFCell getCell() {
		return cell;
	}

	/**
	 * 擾
	 * @return row
	 */
	protected HSSFRow getRow() {
		return row;
	}
	
	/**
	 * ݒ
	 * @param rowno		rowԍ
	 */
	protected void setRow(int rowno) {
		row = sheet.getRow(rowno);
	}
	
	/**
	 * Z̒l擾iString^j
	 * @return l
	 */
	protected String getStringCellValue() {
		return cell.getStringCellValue();
	}

	/**
	 * wZ̒l擾iString^j
	 * @param cellno	cellԍ
	 * @return l
	 */
	protected String getStringCellValue(short cellno) {
		setCell(cellno);
		if (getCell() != null) {
			return cell.getStringCellValue();
		}
		return null;
	}
	
	/**
	 * Z̒l擾idouble^j
	 * @return l
	 */
	protected double getNumberCellValue() {
		return cell.getNumericCellValue();
	}

	/**
	 * Z̒l擾iDate^j
	 * @return l
	 */
	protected Date getDateCellValue() {
		return cell.getDateCellValue();
	}

	/**
	 * wZ̒l擾iString^j
	 * @param cellno	cellԍ
	 * @return value
	 */
	protected String getCellValue(short cellno) {
		String value = "";
		setCell(cellno);
		if (getCell() != null) {
			if (cell.getCellType() == HSSFCell.CELL_TYPE_NUMERIC) {
				value = String.valueOf(Double.valueOf(getNumberCellValue()).intValue());
			} else if (cell.getCellType() == HSSFCell.CELL_TYPE_FORMULA) {
				value = cell.getCellFormula();
			} else if (cell.getCellType() == HSSFCell.CELL_TYPE_BLANK) {
				value = "";
			} else {
				value = getStringCellValue();
			}
		}		
		return value;
	}
	
}
